state QulegPyromancy in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity, quileg_stream		: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;

	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("ep2_mutations_02.bnk") )
		{
			theSound.SoundLoadBank( "ep2_mutations_02.bnk", false );
		}
	
		if ( parent.spell_name == 'fire_vortex' )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
				parent.AddTimer('rotate_towards_target', 0.0001, true );
			}
		}
		else
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		if ( animEventName == 'cast_throw' )
		{
			cast_spells_quileg();
			if ( parent.spell_name != 'winter_souls_tornado' )
			{
				thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
			}
		}
		if ( animEventName == 'cast_end' )
		{
			cast_spells_quileg_meteors();
			cast_spells_fire_vortex();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_quileg()
	{
		var basePos, pos			: Vector;
		var rot 					: EulerAngles;
		var spikeEnt				: CEntity;
		var PositionLocal			: Vector;
		var PositionGlobal			: Vector;
		var polarAngle, unitAngle 	: float;
		var radius, angle		 	: float;
		
		switch( parent.spell_name )
		{
			case 'quileg_shield':
				{
					clear_guarding_buffs( false );
				
					CustomEffect.effectType = EET_QuilegShield;
					CustomEffect.creator = GetWitcherPlayer();
					CustomEffect.duration = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'shield_duration', true, true) );
					GetWitcherPlayer().AddEffectCustom( CustomEffect );
					thePlayer.PlayEffect('mutation_1_igni_power');
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'quileg_stream':
				{
					parent.templatename = "dlc\magicspellsrev\data\entities\quileg.w2ent";
					
					quileg_stream = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), thePlayer.GetWorldPosition() );
					quileg_stream.PlayEffect('quileg_stream');
					quileg_stream.CreateAttachment( thePlayer, 'l_weapon');
					quileg_stream.AddTag('spells_alt_stream');
					
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					register_cancel_input_spells();
					
					parent.stream_hits.Clear();
					
					cast_spells_stream_quileg();
				}

				break;
			case 'quileg_blast':
				{
					
					position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward();
					position = TraceFloor( position );
					position.Z += 1.5;
					
					parent.templatename = "dlc\magicspellsrev\data\entities\quileg_blast.w2ent";
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, thePlayer.GetWorldRotation() );
					main_effect.PlayEffect( 'blast_lv2' );
					main_effect.PlayEffect( 'blast_lv0' );
					main_effect.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
					thePlayer.PlayEffect('mutation_1_igni_power');
					thePlayer.SoundEvent('sign_igni_charge_begin');
					thePlayer.SoundEvent('sign_igni_charge_begin');
					
					theGame.GetSurfacePostFX().AddSurfacePostFXGroup( TraceFloor( position ), 1.f, 15, 2.f, 15.f, 1);
					
					GCameraShake( 0.4, true, position, 30.0f);
					
					FindGameplayEntitiesInRange( entities, thePlayer, 8, 100 );
					for ( i = 0; i <= entities.Size(); i+=1 )
					{
						entities[i].OnIgniHit( NULL );
					}
					
					actors = thePlayer.GetNPCsAndPlayersInRange( 8, 100, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
					for( i = 0; i < actors.Size(); i += 1 )
					{
						target = (CActor)actors[i];
						damage_value = get_damage_value_for_blasts( target, GetMagicVigil().get_magic_spellpower() );
						
						damage_action =  new W3DamageAction in this;
						damage_action.Initialize(thePlayer,target,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false, false, true, false );
						damage_action.SetProcessBuffsIfNoDamage(true);
						damage_action.SetHitReactionType(EHRT_Heavy);
						damage_action.SetHitEffect('igni_cone_hit', false, false);
						damage_action.SetHitEffect('igni_cone_hit', true, false);
						damage_action.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage_value );
						if( RandF() < 0.25 ) 
						{ 
							damage_action.AddEffectInfo( EET_Burning, 2 ); 
						}
						else
						{
							damage_action.AddEffectInfo( EET_Stagger );
						}
						
						if ( spells_can_dismember( target ) )
						{
							damage_action.SetForceExplosionDismemberment();
						}
						
						effect_entity = target.CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
						effect_entity.PlayEffect( 'flame' );
						effect_entity.DestroyAfter(5);
						
						theGame.damageMgr.ProcessAction( damage_action );
						delete damage_action;
					}
				}
				
				break;
			default:		
				break;
		}
	}
	
	
	private function cast_spells_fire_vortex()
	{
		var vortex 	: W3FireVortex;
	
		if ( parent.spell_name == 'fire_vortex' )
		{
			theGame.GetEntitiesByTag('fire_vortex_spells',ents_destroy);
			for( i=0; i<ents_destroy.Size(); i+=1 )
			{
				ents_destroy[i].AddTimer('destroy_fire_vortex',0.0f);
			} 	
			
			parent.templatename = "dlc\magicspellsrev\data\entities\quileg_fire_vortex.w2ent";
		
			duration = 10;
			duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
		
			position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*6;
		
			position = find_position_spells( position );
		
			vortex = (W3FireVortex)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), thePlayer.GetWorldRotation());
			vortex.AddTimer('destroy_fire_vortex', duration );
			vortex.AddTag('fire_vortex_spells');
			vortex.AddTag( 'spells_from_sign' );
			
			theGame.GetSurfacePostFX().AddSurfacePostFXGroup( TraceFloor( position ), 1.f, duration, 1.f, 10.f, 1);
			
			Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
		}
	}
	
	private function cast_spells_quileg_meteors()
	{
		var victimstofire			: array<CActor>;
		var initpos					: Vector;
		var minimeteor 				: W3QuilegMeteor;
		var portal 					: CEntity;
	
		if ( parent.spell_name == 'quileg_meteors' )
		{
			if ( thePlayer.IsInInterior() )
			{
				theGame.GetGuiManager().ShowNotification( GetLocStringByKeyExt( "menu_cannot_perform_action_here" ),, true );
			}
			else
			{
				victimstofire = thePlayer.GetNPCsAndPlayersInRange( thePlayer.findMoveTargetDistMax, 20, ,FLAG_ExcludePlayer + FLAG_OnlyAliveActors+ FLAG_Attitude_Hostile);
				if ( victimstofire.Size() >0 )
				{
					if ( parent.actor )
					{
						initpos = parent.actor.GetWorldPosition();
					}
					else
					{
						initpos = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward() * 3;
					}
				
					initpos.Z += 3.5;
					
					portal = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\portal_for_golems.w2ent", true ), initpos );
					portal.PlayEffect('teleport');
					portal.StopAllEffects();
					portal.DestroyAfter( 2.5 );

					for( i = 0; i < victimstofire.Size(); i += 1 )
					{
						if ( GetAttitudeBetween( victimstofire[i], thePlayer ) == AIA_Hostile && victimstofire[i].IsAlive() )
						{
							targetPosition = victimstofire[i].PredictWorldPosition( 0.7 );
							
							minimeteor = (W3QuilegMeteor)theGame.CreateEntity( 
							(CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\quileg_dracolizard_meteor.w2ent", true ), initpos );
							minimeteor.AddTag( 'spells_from_sign' );
							minimeteor.Init(NULL);
							minimeteor.ShootProjectileAtPosition( 0, 4.5+RandRange(1,5), targetPosition, 500 );
						}
					}
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
			}
		}
	}
		
		
	private entry function cast_spells_stream_quileg()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victimburn, victim					: CActor;
		var damage 								: float;
		var channelDmg 							: SAbilityAttributeValue;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity, effectsound, ground	: CEntity;
		var coll, normal 						: Vector;
		var lastpos 							: Vector;
		var lastpos2 							: Vector;
		var entities							: array<CGameplayEntity>;
		var	timestamp							: float;
		var colls								: array< name >;
		var Burn								: SCustomEffectParams;
		var results 							: array<SRaycastHitResult>;
		var res, effect_expl					: CEntity;
		var ind 								: int;
		var min 								: float;
		var can_burn							: bool;
		
		colls.Clear();
		colls.PushBack( 'Terrain' );
		
		effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\quileg_stream_collision.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
		effectentity.AddTag('spells_stream_collision');
		
		effectsound = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\quileg.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
		effectsound.SoundEvent("fx_fire_burning_strong_begin");
		effectsound.SoundEvent("fx_fire_burning_strong_begin");
		effectsound.SoundEvent("fx_fire_burning_body_strong_loop");
		effectsound.SoundEvent("fx_fire_burning_body_strong_loop");
		effectsound.AddTag('spells_stream_collision_sound');
		
		can_burn = false;
		
		while ( true )
		{
			if (  thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 40 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
				
				results.Clear();
				FindActorsAtLine( position, targetPosition, 0.1f, results );
				
				if ( results.Size() > 0 )
				{
					min = results[0].distance;
					ind = 0;
					for( i=1; i<results.Size(); i+=1 )
					{
						if(results[i].distance < min)
						{
							min = results[i].distance;
							ind = i;
						}
					}
				}
				
				if(results[ind].component)
				{
					res = results[ind].component.GetEntity();
					
					if ( !parent.stream_hits.Contains( ((CGameplayEntity) res) ) && !((CGameplayEntity) res).HasTag('spells_custom_projs') )
					{
						((CGameplayEntity) res).OnIgniHit( NULL );
						parent.stream_hits.PushBack( ((CGameplayEntity) res) );
					}
					
					victim = (CActor)res;
			
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = get_damage_value_for_stream( victim, GetMagicVigil().get_magic_spellpower() );
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							damage *= 0.5;
						
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 5 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						else
						{
							damage_action_stream.AddEffectInfo( EET_Burning, 1 ); 
						}
						
						damage_action_stream.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage );
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
						damage_action_stream.SetHitAnimationPlayType(EAHA_Default);
						
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
					
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
						
						if( !victim.IsAlive() )
						{
							effect_expl = victim.CreateFXEntityAtPelvis( 'mutation_2_explode', true );
							effect_expl.PlayEffect( 'mutation_2_igni' );
							effect_expl.DestroyAfter(5);
						}
					}
				}
				
				if( theGame.GetWorld().SweepTest( position + castDir, targetPosition, 0.1, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffect('collision_fx');
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
					theGame.GetEntityByTag( 'spells_stream_collision_sound' ).Teleport(lastpos);
					
					if ( VecDistance( lastpos2, coll ) > 0.2 )
					{
						lastpos2 = coll;
						theGame.GetSurfacePostFX().AddSurfacePostFXGroup( lastpos2, 0.3f, 8.0f, 1.0f, 1.0f, 1 );
					}
					
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopEffect('collision_fx');
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(targetPosition);
					theGame.GetEntityByTag( 'spells_stream_collision_sound' ).Teleport(targetPosition);
				}
				
				if ( ( EngineTimeToFloat( theGame.GetEngineTime() ) - timestamp ) > 0.15 )
				{
					timestamp = EngineTimeToFloat( theGame.GetEngineTime() );
					quileg_stream.PlayEffect('quileg_stream_act', theGame.GetEntityByTag( 'spells_stream_collision' ) );
					quileg_stream.PlayEffect('quileg_stream_act', theGame.GetEntityByTag( 'spells_stream_collision' ) );
				}
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	
	event OnLeaveState( nextStateName : name )
	{
	}
}